#modname "MA Quijote v6.3.1"
#description "Adds the custom nation of Quijote to Middle Ages. Quijote is a realm of native kingdoms influenced by a manipulating, conspiring god. They have no traditional army and rely on powerful heroes and roving adventurers. Quijote has unreliable access to every path of magic, as wizards from far and wide abandon their posts to answer its call."
#icon "MA_Quixote/Quixote_Banner.tga"
#version 6.3.1

--CHANGELOG:
--1.0.1 : started this changelog, fixed broken ritual 'appoint escudero'. Made 'reveal identity' properly display it's free. Fixed issues with the 'create giant' spell. Changed item and monster numbers to make compatible with DE. Cleaned up mod for easier readibility and modularity.
--1.1:added 2 heros and 1 multi-hero; Master Alchemist, Blood Noble, and Great Astrologer. removed Duque's +1 inspirational.
--1.1.1: lowered research level of raise castle from 9 to 7.
--2: lowered blood noble's age, change helmet of hidalgo from half-helmet to iron cap. Re-wrote description of "Imported Effigy". Added description and details to "Reveal Identity" spell. Made "hero from afar" event luck-based. Added more units to hero from afar pool. Remade the rogue. Added Almogavar. Increased morale of all sacreds. Made the Vainquer, Tirador, and Knight-Errant multi heros. Added Ecorcheur. Added Routier. Made all sacreds cheaper. Added Condottieri. Lowered Duque's insanity chance. Made Appoint Escudero Cheaper and fire-based. Increased priest level of promoted sacreds. Added site numbers to be compatible with other mods.
--2.0.1: Manually Set Hermano to formation fighter 0, as SCBM makes them formation fighter 3. Removes Vainquer, Tirador, and Knight-Errant from the multi-hero pool.
--2.0.2: Fixed Condottieri not having a sword or hoof attack. Made Encantador's age auto-calculated. Made Great Astrologer older. Fixed Sacreds only having 11 morale.
--3.0:Changed Encantador to S31F 100% F1/E1 30% F1/E1 20% A1. Increased Call to Errantry's unrest and popkill generation to no longer have a negligible effect, and added a dire portent message. Nerfed skill and precision of Escrimeur and Ballestero a bit. Adjusted skill of Routiers. changed prices of several units. Gave damsel weapon and armor, and adjusted stats. Removed Bastion of the Sun's construction discount and reduced Academy of the Occult's enchantment discount to 10%. Changed Escrimeur's armor. Scaled down chances to get Heros from Afar. Removed communion master from all apostles. Made call to errantry less likely and spawn less units. Added Alchemist to national roster. Made Ecorcheur also recruitable in forts.
--6.3.1: Quijote converted to Dominions 6. Magicians now have 2/1 path split instead of 3 random. New mages of the Hidden Order added as national recruits. Added new Dom6 commanders to Hero from Afar. Added more thematic Pretender options, and adjusted cheapgods.

-- Weapon slots: 1359-1360
-- Unit slots: 6712 - 6782
-- Enchantment slots: 641
-- Nation slots: 146
-- Site slots: 1910-1911

-------- WEAPONS --------

#newweapon 1359
#name "Spada da Lato"
#dmg 6
#nratt 1
#att 1
#def 2
#len 2
#sound 8
#rcost 4
#fullstr
#aoe 0
#ironweapon
#slash
#pierce
#end

#newweapon 1360 --used to make tiradors shoot faster
#copyweapon 25
#name "Crossbow"
#nratt 1
#end

-------- ITEMS --------

#selectitem 600
#name "Imported Effigy"
#descr "A small, insignificant trinket that has some personal significance. It is common for far-away travelers and wandering heroes to bring mementos of their homeland, which will be cast aside or destroyed during their induction into Quijote's campaign, completing their betrayal and total conversion to their new faith and dogma."
#constlevel 12
#copyspr 409
#type 8
#mainpath 4
#mainlevel 1
#spell "Reveal Identity"
#nofind
#cursed
#end


-------- SPELLS --------

-----BACKEND SPELLS
-- Copied from DE
#newspell
#copyspell 1420 -- Rejuvenate
#name "Renewal"
#descr "A 9950 year de-age"
#damage -9950
#spec 0
#school -1
#researchlevel 0
#end

#newspell
#copyspell 1271
#name "Self Weaken"
#effect 67
#damage 3
#school -1
#researchlevel 0
#end

#newspell
#copyspell 1271
#name "Fear Aura"
#effect 23
#damage 16
#school -1
#researchlevel 0
#nextspell "Self Weaken"
#end

#newspell
#copyspell 1271
#name "Self-buff strength"
#effect 10
#damage 128
#school -1
#researchlevel 0
#end

#newspell 
#copyspell 1299 -- gnome lore
#name "Hero Revealed"
#school -1
#researchlevel 0
#path 0 4
#pathlevel 0 1
#fatiguecost 0
#damage -3000
#effect 10021
#nreff 1
#end

#newspell
#name "Reveal Identity"
#descr "While the madness of Quijote is usually contained to its Castilian population, great heroes from distant lands will occasionally fall victim to its toxic influence. Feeling the call, they will abandon their former lives and make the pilgrimage to the land of errantry. Shrouded in a mysterious disguise, they are useless in this form, and in order to join Quijote's campaign, they must reveal their identity by partaking in a ritualistic initiation, wherein, after a period of sombre meditation, they discard all aspects and allegiances of their former selves, finalizing their betrayal to their homeland."
#details "Permanently transforms the unit casting this spell into a random leader or adventurer."
#school -1
#researchlevel 0
#path 0 4
#pathlevel 0 1
#effect 10082
#nreff 1
#damage 642
#fatiguecost 0
#nextspell "Hero Revealed"
#hiddenench 1
#end

----RITUALS
#newspell
#name "Create Giant"
#descr "The caster permanently transforms an able-bodied man into the form of a Giant. This is an amateur and harsh enchantment, and the body or mind of the unit may be harmed in the process."
#details "Giant does not gain commander status."
#school 2
#researchlevel 4
#path 0 6
#pathlevel 0 2
#fatiguecost 700
#effect 10001
#damage -2230
#nreff 1
#restricted "Quijote"
#end

#newspell
#name "Become Giant"
#descr "The caster permanently transforms themselves into the form of a Giant. The new body will be healthy and will retain the mind of the mage, along with any magical skills. Inanimate beings cannot change their form in this manner, and some especially powerful unique beings will resist attempts to change their form and cannot be affected."
#details "Lost limbs are still lost after the transformation."
#school 4
#researchlevel 5
#path 0 6
#pathlevel 0 3
#path 1 4
#pathlevel 1 1
#effect 10130
#fatiguecost 2500
#damage 6762 -- Transformed Giant
#nreff 1
#nextspell "Renewal"
#spec 536870912 -- No effect on Lifeless
#restricted "Quijote"
#end

#newspell
#name "Improved Create Giant"
#descr "The caster permanently transforms an able-bodied man into the form of a Giant. This is an improved version of an amateur and brutal ritual, and the techniques used in this spell do not harm the target."
#details "Giant does not gain commander status."
#school 2
#researchlevel 7
#path 0 6
#path 1 4
#pathlevel 0 3
#pathlevel 1 1
#effect 10001
#fatiguecost 700
#damage -2231
#nreff 1
#restricted "Quijote"
#end

#newspell
#name "Become Dragon"
#descr "The caster attempts to permanently transform themselves into the form of a great Red Dragon. If successful the new body will be healthy and will retain the mind of the mage. The Dragon will retain any magic skills learned before the transformation took place, and Fire magic will be easier whilst in Dragon form. Inanimate beings cannot change their form in this manner, and some especially powerful unique beings will resist attempts to change their form and cannot be affected."
#details "Afflictions are not healed, Dragon gains +1F boost."
#school 4
#researchlevel 6
#path 0 0
#pathlevel 0 4
#effect 10130
#fatiguecost 2500
#damage 6763 -- Transformed Dragon
#nreff 1
#nextspell "Renewal"
#spec 536870912 -- No effect on Lifeless
#restricted "Quijote"
#end

#newspell
#name "The Call to Errantry"
#descr "This mighty enchantment represents the final perfection of Quijote's power, wherein the caster releases a shockwave of incredible arcane energy. The madness previously only felt by Quijote's forces and its heroes will now spread amongst the entire world, calling every farmer, soldier, beggar, and villain to become an adventurer and serve Quijote. Chaos and dilapidation will follow, and the enchantment will stay in effect until it is dispelled, Quijote is destroyed, or there is nobody left to answer it."
#school 5
#researchlevel 7
#path 0 4
#pathlevel 0 4
#fatiguecost 7000
#damage 641 -- Triggers events
#effect 10081 
#nreff 1
#restricted "Quijote"
#end

#newspell 
#copyspell 901 --Wizard Tower
#name "Raise Castle"
#descr "The caster molds and enlarges a landmark in the center of the province he's currently in, turning a peasant's house or a simple cave into a strong and magnificent castle."
#fatiguecost 3000
#school 3
#path 0 4
#pathlevel 0 6
#path 1 3
#pathlevel 1 1
#damage 
#researchlevel 7
#restricted "Quijote"
#damage 3 --castle
#end

#newspell
#copyspell 1349 -- divine name
#name "Appoint Escudero"
#descr "The caster uses an arcane enchantment to bring out the inherent potential of a sacred unit of Quijote. After a series of blessings and rituals, the unit is gifted a noble title and an empowered intellect, giving them commander status. This spell can only be used on the sacred and skilled units of Quijote and will fail if used on any other units."
#details "Can only be used on the Ballestero, Escrimeur, and Hidalgo units. When turned into commanders, These units gain increased stats, possibility of magic paths, and special abilites."
#restricted "Quijote"
#fatiguecost 1200
#path 0 0
#pathlevel 0 3
#researchlevel 4
#school 5
#spec 32768
#end

#newspell
#copyspell 1283 -- augury
#name "Sortes Sanctorum"
#descr "The caster uses an enchanted text of divination based on the holy scriptures of the previous Pantokrator. The casting of lots will lead to a gnostic passage, revealing hidden sites of holy power in a friendly province of the caster's choice."
#details "Searches for sites of holy magic."
#path 0 9
#pathlevel 0 1
#school 7
#researchlevel 0
#fatiguecost 0
#effect 10048
#damage 8
#restricted "Quijote"
#end

#newspell
#name "Send Villains"
#descr "The caster uses Quijote's madness to take hold of a group of merry men in a province far away. The brigands are loyal to the caster, and will ransack and capture settlements in his name."
#school 0
#researchlevel 2
#path 0 0
#pathlevel 0 1
#path 1 4
#pathlevel 1 1
#fatiguecost 1200
#effect 10037
#damage 482
#nreff 3025
#provrange 5
#farsumcom 1912
#restricted "Quijote"
#end

#newspell
#name "Contact the Apostle of Nature"
#descr "With this powerful ritual the caster contacts a divine apostle. Apostles are revered followers of the previous Pantokrator who aided in his original ascension as Lord. Apostles have ascended to a new form of existence in the Celestial Sphere, and as such do not fear death or hardship. Incredibly powerful mages and priests, they are strong enough to be Pretender Gods in their own right, and the superstitious folk of Quijote are known to create cults and perform worship in their names."
#school 0
#path 0 6
#pathlevel 0 1
#researchlevel 8
#fatiguecost 5000
#effect 10021
#damage 6767
#restricted "Quijote"
#end

#newspell
#name "Contact the Apostle of Fire"
#descr "With this powerful ritual the caster contacts a divine apostle. Apostles are revered followers of the previous Pantokrator who aided in his original ascension as Lord. Apostles have ascended to a new form of existence in the Celestial Sphere, and as such do not fear death or hardship. Incredibly powerful mages and priests, they are strong enough to be Pretender Gods in their own right, and the superstitious folk of Quijote are known to create cults and perform worship in their names."
#school 1
#path 0 0
#pathlevel 0 1
#researchlevel 8
#fatiguecost 5000
#effect 10021
#damage 6768
#restricted "Quijote"
#end

#newspell
#name "Contact the Apostle of Death"
#descr "With this powerful ritual the caster contacts a divine apostle. Apostles are revered followers of the previous Pantokrator who aided in his original ascension as Lord. Apostles have ascended to a new form of existence in the Celestial Sphere, and as such do not fear death or hardship. Incredibly powerful mages and priests, they are strong enough to be Pretender Gods in their own right, and the superstitious folk of Quijote are known to create cults and perform worship in their names."
#school 2
#path 0 5
#pathlevel 0 1
#researchlevel 8
#fatiguecost 5000
#effect 10021
#damage 6769
#restricted "Quijote"
#end

#newspell
#name "Contact the Apostle of Earth"
#descr "With this powerful ritual the caster contacts a divine apostle. Apostles are revered followers of the previous Pantokrator who aided in his original ascension as Lord. Apostles have ascended to a new form of existence in the Celestial Sphere, and as such do not fear death or hardship. Incredibly powerful mages and priests, they are strong enough to be Pretender Gods in their own right, and the superstitious folk of Quijote are known to create cults and perform worship in their names."
#school 3
#path 0 3
#pathlevel 0 1
#researchlevel 7
#fatiguecost 5000
#effect 10021
#damage 6770
#restricted "Quijote"
#end

#newspell
#name "Contact the Apostle of Water"
#descr "With this powerful ritual the caster contacts a divine apostle. Apostles are revered followers of the previous Pantokrator who aided in his original ascension as Lord. Apostles have ascended to a new form of existence in the Celestial Sphere, and as such do not fear death or hardship. Incredibly powerful mages and priests, they are strong enough to be Pretender Gods in their own right, and the superstitious folk of Quijote are known to create cults and perform worship in their names."
#school 4
#path 0 2
#pathlevel 0 1
#researchlevel 8
#fatiguecost 5000
#effect 10021
#damage 6771
#restricted "Quijote"
#end

#newspell
#name "Contact the Apostle of Air"
#descr "With this powerful ritual the caster contacts a divine apostle. Apostles are revered followers of the previous Pantokrator who aided in his original ascension as Lord. Apostles have ascended to a new form of existence in the Celestial Sphere, and as such do not fear death or hardship. Incredibly powerful mages and priests, they are strong enough to be Pretender Gods in their own right, and the superstitious folk of Quijote are known to create cults and perform worship in their names."
#school 5
#path 0 1
#pathlevel 0 1
#researchlevel 8
#fatiguecost 5000
#effect 10021
#damage 6772
#restricted "Quijote"
#end

----COMBAT
#newspell
#copyspell 1126 -- personal regeneration
#name "Intercession of Nature"
#descr "Worship and veneration of saints is prevalent in Quijote. Pious, sacred figures who through their actions obtained an intensely close connection to the Lord, and were redeemed into eternal life in his Sanctorum. While the Pantokrator may be missing, his vast communion of saints remains. Saints are benevolent in nature and will answer prayers and intercessions, but their behavior is enigmatic and incomprehensible. With the spell a priest of Quijote may call out to a saint of the Celestial Sphere, requesting protection or aid in battle, who will respond by altering the caster to make them closer to their image of the Lord. Prayers to a saint of nature result in the caster's skin being covered in quickly growing roots and vine, which will seal wounds and protect from attacks."
#school 0
#path 0 6
#pathlevel 0 1
#path 1 9
#pathlevel 1 1
#researchlevel 2
#ainocast 1
#details "Grants Limited Regeneration and Barkskin."
#nextspell "Barkskin"
#restricted "Quijote"
#end

#newspell
#copyspell 1121 -- breath of winter
#name "Intercession of Fire"
#descr "Worship and veneration of saints is prevalent in Quijote. Pious, sacred figures who through their actions obtained an intensely close connection to the Lord, and were redeemed into eternal life in his Sanctorum. While the Pantokrator may be missing, his vast communion of saints remains. Saints are benevolent in nature and will answer prayers and intercessions, but their behavior is enigmatic and incomprehensible. With the spell a priest of Quijote may call out to a saint of the Celestial Sphere, requesting protection or aid in battle, who will respond by altering the caster to make them closer to their image of the Lord. Prayers to a saint of fire result in the caster being enveloped in all-encompassing flame, burning attackers and emanating unbrearable heat to those around them. Even the caster is not protected from the intensity of these flames, and as the battle presses on they will eventually fall as a rightful martyr to Fire."
#damage 16384
#spec 16384
#ainocast 1
#fatiguecost 30
#nreff 1
#school 1 --Alteration
#path 0 0
#pathlevel 0 1
#path 1 9
#pathlevel 1 1
#researchlevel 2
#spec 8404992
#details "Grants Heat Aura 4 (increased by +1 per extra mage level, or +3 to existing Heat Aura), and Fire Shield. Does not grant fire resistance."
#nextspell "Fire Shield"
#restricted "Quijote"
#end

#newspell
#copyspell 764 -- skeletal body
#name "Intercession of Death"
#descr "Worship and veneration of saints is prevalent in Quijote. Pious, sacred figures who through their actions obtained an intensely close connection to the Lord, and were redeemed into eternal life in his Sanctorum. While the Pantokrator may be missing, his vast communion of saints remains. Saints are benevolent in nature and will answer prayers and intercessions, but their behavior is enigmatic and incomprehensible. With the spell a priest of Quijote may call out to a saint of the Celestial Sphere, requesting protection or aid in battle, who will respond by altering the caster to make them closer to their image of the Lord. Veneration of the saints of death is taboo in Quijote and is only done by evil magicians, bandits, and witches. Prayers to a saint of death result in the caster being contorted into a half-dead, ghoulish form. Their body will become dried and thin, and they will become terrifying to behold, sending enemy soldiers into a panic."
#school 2
#path 0 5
#pathlevel 0 1
#path 1 9
#pathlevel 1 1
#researchlevel 2
#fatiguecost 30
#ainocast 1
#details "Grants Skeletal Body and a Fear aura, but also weakens the caster."
#nextspell "Fear Aura"
#restricted "Quijote"
#end

#newspell
#copyspell 812 -- stoneskin
#name "Intercession of Earth"
#descr "Worship and veneration of saints is prevalent in Quijote. Pious, sacred figures who through their actions obtained an intensely close connection to the Lord, and were redeemed into eternal life in his Sanctorum. While the Pantokrator may be missing, his vast communion of saints remains. Saints are benevolent in nature and will answer prayers and intercessions, but their behavior is enigmatic and incomprehensible. With the spell a priest of Quijote may call out to a saint of the Celestial Sphere, requesting protection or aid in battle, who will respond by altering the caster to make them closer to their image of the Lord. Prayer to a saint of the earth will result in the caster being made closer to the aspect of the golem, gaining skin of hard clay and increased strength."
#school 3
#path 0 3
#pathlevel 0 1
#path 1 9
#pathlevel 1 1
#researchlevel 3
#fatiguecost 30
#details "Grants Stoneskin and increased strength."
#nextspell "Self-buff strength"
#restricted "Quijote"
#end

#newspell
#copyspell 773 -- quicken self
#name "Intercession of Water"
#descr "Worship and veneration of saints is prevalent in Quijote. Pious, sacred figures who through their actions obtained an intensely close connection to the Lord, and were redeemed into eternal life in his Sanctorum. While the Pantokrator may be missing, his vast communion of saints remains. Saints are benevolent in nature and will answer prayers and intercessions, but their behavior is enigmatic and incomprehensible. With the spell a priest of Quijote may call out to a saint of the Celestial Sphere, requesting protection or aid in battle, who will respond by altering the caster to make them closer to their image of the Lord. Prayer to a saint of water will result in the caster being made closer to the aspect of water. They will take on a form similar to a water elemental, allowing them to move in quick, complex maneuvers, and absorb damage more easily."
#school 4
#path 0 2
#pathlevel 0 1
#path 1 9
#pathlevel 1 1
#researchlevel 2
#fatiguecost 30
#details "Grants Quickness and Liquid Body."
#nextspell "Liquid Body"
#restricted "Quijote"
#end

#newspell
#copyspell 784 -- mirror image
#name "Intercession of Air"
#descr "Worship and veneration of saints is prevalent in Quijote. Pious, sacred figures who through their actions obtained an intensely close connection to the Lord, and were redeemed into eternal life in his Sanctorum. While the Pantokrator may be missing, his vast communion of saints remains. Saints are benevolent in nature and will answer prayers and intercessions, but their behavior is enigmatic and incomprehensible. With the spell a priest of Quijote may call out to a saint of the Celestial Sphere, requesting protection or aid in battle, who will respond by altering the caster to make them closer to their image of the Lord. Prayer to a saint of air will result in the caster's body being refracted into a multitude of illusions, and becoming mist. Striking the mist that makes up the mage's body causes the mage very little damage. The mistform will end if the mage gets hit exceptionally hard or by a magical weapon."
#school 5
#path 0 1
#pathlevel 0 1
#path 1 9
#pathlevel 1 1
#researchlevel 2
#fatiguecost 30
#details "Grants Mirror Image and Mistform."
#nextspell "Mistform"
#restricted "Quijote"
#end

--Maybe a blood spell that summons demons? TBD

#newspell
#copyspell 200 -- blessing
#name "Blessing of the Apostolorum"
#descr "With this spell, the caster is able to send a message through the astral planes and contact an Apostle of the Celestial Sphere. The Apostles are immensely powerful immortal messengers who have ascended into an new state of existence via the previous Pantokrator. They feel unconditional love towards all beings of the earth, and cannot comprehend the Awakening War. The Apostle will act through the caster, blessing a large squad on the battlefield with the grace of the Lord. Unlike a normal blessing from the Awakening God, this blessing does not discriminate between ally or enemy, and does not work on beings with no soul. Beings from the void will also not be affected by this spell. Highly magical units may resist this spell."
#school 5
#researchlevel 5
#path 0 4
#pathlevel 0 3
#aoe 1030
#spec 4661930118217728
#casttime 200
#restricted "Quijote"
#fatiguecost 20
#end

#newspell
#copyspell 220 -- divine blessing
#name "Blessing of the Sanctorum"
#descr "This long and arduous spell allows the caster to briefly travel through the astral planes and enter a communion with the Sanctorum of the Celestial Sphere. Possessed by their amassed holy power, they will bless every unit on the battlefield, regardless if they are ally or enemy. After this, the possession will end and the mage will be forced out of the communion, exhausting them greatly. This blessing does not work on beings with no soul, or beings from the void. Highly magical units may resist this spell."
#school 5
#researchlevel 9
#path 0 4
#pathlevel 0 6
#spec 17592731435008
#casttime 500
#fatiguecost 70
#restricted "Quijote"
#end

-----

#selectspell 448 --Holy Pyre
#restricted "Quijote"
#end

#selectspell 478 -- Contact Harbinger
#restricted "Quijote"
#end

#selectspell 480 -- Angelic Host
#restricted "Quijote"
#end

#selectspell 482 -- Heavenly Choir
#restricted "Quijote"
#end

-------- MAGIC SITES --------

#newsite 1910
#name "Bastion of the Sun"
#look 3
#path 0
#level 0
#rarity 5
#gems 0 2 -- 2F
#homecom "Damsel"
#homecom "Duque"
#end

#newsite 1911
#name "Academy of the Occult"
#look 3
#path 4
#level 0
#rarity 5
#gems 4 3 -- 3S
#enchcost 10
#homecom "Encantador"
#homecom 3488
#end

-------- PRETENDERS --------
-- Heros --

#newmonster 6775
#copystats 551
#name "Master Alchemist"
#fixedname "Nicolas"
#spr1 "MA_Quixote/QuixoteHeroAlchemist1.tga"
#spr2 "MA_Quixote/QuixoteHeroAlchemist2.tga"
#descr "Nicolas is an alchemist of legend, and possibly the most powerful one to ever exist. Using the mysteriously uncovered grimoire of Abramelin, He deciphered the recipe for the Great Work, the magnum opus of all alchemy. He can turn any metal into gold, revert substances to their base elemental form, and has perfected the composition of his own body making him immortal and immune to illness. He is extraordinarily charitable, asking for no stipend and donating all of the profits of his research to the poor and the clergy. An expert alchemist, Nicolas is able to conjure the Green Lion by drawing out the vitriol from common materials."
#unique
#gcost 0
#hp 15
#mr 18
#mor 14
#str 11
#prec 11
#maxage 1000
#alchemy 100
#magicskill 0 2
#magicskill 2 2
#magicskill 3 1
#magicskill 4 2
#magicskill 1 1
#researchbonus 4
#latehero 12
#makemonsters1 1983
#gold 50
#heal
#diseaseres 100
#startitem 353
#end

#newmonster 6776
#copystats 2539
#cleararmor
#clearweapons
#name "Blood Noble"
#fixedname "Gilles"
#spr1 "MA_Quixote/QuixoteHeroBloodNoble1.tga"
#spr2 "MA_Quixote/QuixoteHeroBloodNoble2.tga"
#descr "A veteran commander in the army of a petty Duke, Gilles' retirement from military service was plagued with debauchery. He ravaged his own family fortune on reckless spending and went into horrible debt with almost every connection he had in the aristocratic world. Desperate to rise from his own failure, Gilles turned to alchemy and the occult. He used countless tinctures and solutions to prolong his own lifespan, and after failing to transmute gold, he sought to summon a demon to grant his wishes. Eventually Gilles' pursuits in dark magic were exposed to the Church, along with accusations of kidnapping and serial murder. He was to be hanged but avoided this fate by pledging himself to the awakening Lord in his confession. Released and enlisted in the Awakening Lord's campaign, Gilles still proves to be a terror to the lands he visits, and he must be kept far from the peasants lest they lynch him. Gilles is a proficient soldier in combat and became famous for the unstoppable rage that would arise should he be injured on the battlefield."
#unique
#mr 14
#att 12
#prec 11
#startage 110
#addrandomage 6
#maxage 200
#alchemy 25
#magicskill 0 1
#magicskill 3 1
#magicskill 3 1
#magicskill 4 1
#magicskill 8 3
#berserk 3
#pillagebonus 5
#latehero 5
#incunrest 2
#armor 19
#weapon 18
#end

#newmonster 6777
#copystats 301
#clearmagic
#startage 25
#name "Great Astrologer"
#nametype 114
#spr1 "MA_Quixote/QuixoteHeroAstrologer1.tga"
#spr2 "MA_Quixote/QuixoteHeroAstrologer2.tga"
#descr "The astrologers of Quijote are genius occultists and high aristocrats. They typically join the courts of nobles, dukes, and kings as advisors due to their mastery of divination and invaluable ability to predict the future. Great Astrologers are masters of the stars and powerful scholars, empowering their abilities in the magical arts. Great Astrologers will slightly empower the research abilities of other mages in the province they are in and have a chance to prevent bad events."
#armor 158
#mr 15
#mor 11
#str 10
#gcost 0
#nobadevents 15
#magicskill 4 3
#custommagic 3712 100
#researchbonus 6
#inspiringres 1
#end


-- Leaders --

#newmonster 6712
#copystats 426
#clearweapons
#name "Adventurer"
#spr1 "MA_Quixote/QuixoteScout1.tga"
#spr2 "MA_Quixote/QuixoteScout2.tga"
#descr "A lowly vagabond who wanders about in search of magical treasure, or the completion of some fantastical quest. The adventurers of Quijote are numerous and forthcoming, and are willing to scout, spy, and campaign in the service of the Awakening God. Most adventurers will not aspire to much, but extraordinary ones may be made prophets, and turn into great and powerful heros."
#rcost 1
#rpcost 10000
#gcost 10010
#hp 12
#str 11
#att 11
#def 11
#prec 13
#mor 12
#weapon 7
#weapon 23
#itemslots 2039814
#stealthy 15
#spy
#maxage 50
#nametype 114
#noleader
#prophetshape 6713
#end

#newmonster 6714
#copystats 148
#name "Friar"
#spr1 "MA_Quixote/QuixoteFriar1.tga"
#spr2 "MA_Quixote/QuixoteFriar2.tga"
#descr "Friars are traveling monks who preach against the false faiths of the world. The friars of Quijote are less trained in the ways of war than those of Marignon, and spend most of their time traveling between isolated monasteries. They have some knowledge of the occult, and have been known to put simple enchantments or troublesome hexes on intrepid travellers."
#gcost 10010
#att 10
#prec 11
#armor 158
#poorleader
#montag 3001
#nametype 114
#custommagic 65408 100
#end

#newmonster 6715
#copystats 1182
#clearmagic
#clearspec
#name "Magician"
#spr1 "MA_Quixote/QuixoteWizard1.tga"
#spr2 "MA_Quixote/QuixoteWizard2.tga"
#descr "The magicians of Quijote are mysterious mages who spend time causing mischief and harassing the populace. Magicians are reclusive and selfish but have been called to service by the Awakening God. They travel to Quijote from faraway lands and may know exotic or rare magics."
#startage 25
#gcost 130
#rpcost 10000
#custommagic 65408 200
#custommagic 65408 100
#end

#newmonster 6716
#copystats 223
#clearmagic
#clearspec
#clearweapons
#name "Encantador"
#descr "Encantadors are esteemed graduates of Quijote's illusive magic academies. In Quijote, studious proteges of the natural sciences are headhunted by powerful occultists, and trained in the arts of thaumaturgy and spellcasting. Encantadors typically take the role of court sorcerers and alchemists for native and foreign kingdoms, and while they are not used to warfare, they are immensely proficient in research and ritual."
#spr1 "MA_Quixote/QuixoteEnchanter1.tga"
#spr2 "MA_Quixote/QuixoteEnchanter2.tga"
#startage 0
#gcost 10010
#weapon 9
#alchemy 50
#poorleader
#researchbonus 8
#slowrec
#magicskill 4 3 --S3
#magicskill 0 1 --F1
#custommagic 1152 100 -- 100% F1/E1
#custommagic 1152 30 -- 30% F1/E1
#custommagic 256 20 --20% A1
#nametype 114
#end

#newmonster 6717
#copystats 428
#clearweapons
#clearspec
#name "Rogue"
#descr "The rogues who answer Quijote's call are skilled in the arts of stealth and subterfuge. They can pass through enemy territory unseen and are skilled combatants. Rogues enjoy entering enemy encampments and challenging commanders to duels, giving no care to whether or not they actually accept."
#spr1 "MA_Quixote/QuixoteRogue1.tga"
#spr2 "MA_Quixote/QuixoteRogue2.tga"
#mr 12
#att 14
#def 14
#mor 14
#weapon "Spada da Lato"
#weapon 9
#stealthy 20
#ambidextrous 3
#assassin
#nametype 114
#end

#newmonster 6718
#copystats 426
#clearweapons
#cleararmor
#clearmagic
#clearspec
#name "Damsel"
#spr1 "MA_Quixote/QuixoteDamsel1.tga"
#spr2 "MA_Quixote/QuixoteDamsel2.tga"
#descr "Quijote is not represented by one unified empire but rather a collection of fragile, bickering alliances between its numerous dukes and marquis. The call to adventure of the Awakening God is what has forced these domains into agreement, and once the Awakening God rises as Pantokrator they will undoubtedly collapse into their rivalries once more. Damsels are the noble ladies of the Quijote courts and are able to take the role of agent and diplomat. They can infiltrate foreign territory to seduce and manipulate enemy commanders. They may not be warriors, but it is not uncommon for them to have some knowledge of the occult, being secretly trained by noble mages and witches."
#gcost 10010
#rpcost 2
#str 8
#att 9
#mr 12
#mor 10
#prec 11
#poorleader
#female
#seduce 11
#stealthy 20
#nametype 119
#custommagic 2176 20
#armor 158
#weapon 9
#end

#newmonster 6719
#copystats 3377
#clearspec
#cleararmor
#clearweapons
#clearmagic
#name "Duque"
#spr1 "MA_Quixote/QuixoteKing1.tga"
#spr2 "MA_Quixote/QuixoteKing2.tga"
#descr "Quijote is not represented by one unified empire but rather a collection of fragile, bickering alliances between its numerous dukes and marquis. The call to adventure of the Awakening God is what has forced these domains into agreement, and once the Awakening God rises as Pantokrator they will undoubtedly collapse into their rivalries once more. Duques are the most powerful nobles of the fiefs of Quijote and seek to emulate the brave kings and emperors of legend. They are old and mad, but their delusional courage makes them powerful generals for Quijote's hordes. Due to the martial arts training of their noble upbringing, they are also competent swordsmen."
#gcost 10040
#rcost 1
#rpcost 4
#startage 40
#addrandomage 18
--#inspirational 1
#expertleader
#armor 148
#armor 11
#weapon 8
#weapon 25
#nametype 114
#startaff 30
#insane 1
#end

#newmonster 6782
#copystats 44
#cleararmor
#clearweapons
#name "Condottiero"
#spr1 "MA_Quixote/QuixoteMercenaryLeader1.tga"
#spr2 "MA_Quixote/QuixoteMercenaryLeader2.tga"
#unmountedspr1 "MA_Quixote/QuixoteMercenaryLeaderNM1.tga"
#unmountedspr2 "MA_Quixote/QuixoteMercenaryLeaderNM2.tga"
#descr "In the wilderness and borderlands of Quijote live foreign mercenaries and unscrupulous brigands. The Condottieri lead companies of mercenaries and villains, taking contracts from dukes to war and pillage in their name. They ride a horse giving them increased flexibility, and are well expierenced in both leadership and combat. Condottieri are very wealthy, and can afford very good equipment."
#gcost 10010
#rcost 20
#ressize 2
#armor 14
#armor 21
#weapon 25
#weapon 8
#att 11
#def 11
#ap 21
#mapmove 20
#pillagebonus 3
#skilledrider 2
#mountmnr 3517 -- destrier
#end

-- Soldiers/Monsters --

#newmonster 6720
#copystats 2110
#cleararmor
#clearweapons
#name "Hermano"
#spr1 "MA_Quixote/QuixotePolice1.tga"
#spr2 "MA_Quixote/QuixotePolice2.tga"
#descr "Quijote has never gone to war and has no organized army, nor the infrastructure to create one. Hermanos are the guards of the street and city, members of the volunteer brotherhoods that formed in the domain's early years as a response to its lawlessness. They mostly deal with banditry, looters, and wild animals, and due to their tight numbers and lack of preparation can only be recruited in limited quantities."
#mor 9
#gcost 10010
--#reclimit 5/1
#nametype 114
#armor 20
#armor 10
#weapon 28
#formationfighter 0
#end

#newmonster 6721
#copystats 219 -- Marignon swordsman
#clearweapons
#cleararmor
#spr1 "MA_Quixote/QuixoteFencer1.tga"
#spr2 "MA_Quixote/QuixoteFencer2.tga"
#name "Escrimeur"
#descr "The cities of errantry are filled with schools dedicated to the art of swordplay and fencing, and every man in Quijote carries a blade for the purpose of self-defense and dueling. Escrimeur are the elite fencers of Quijote, masters of armed fighting who can dispatch foes in instant, effortless movements. Their swords are specially designed to be light while delivering deadly slashes and stabs, and their study of positioning and movement in combat allows them to fight in loose formations without becoming disorganized. Quijote is a land of heroes, and an exceptional Escrimeur may be turned into a commander via ritual, and in the process become a powerful icon and gain abilities far beyond their usual potential."
#gcost 20
#rpcost 20
#rcost 1
#hp 12
#str 11
#att 13
#def 14
#mor 14
#weapon "Spada da Lato"
#magicskill 9 2
#custommagic 2176 100
#holy
#skirmisher 1
#armor 10
#armor 120
#nametype 114
#end

#newmonster 6722
#copystats 218 -- Marignon crossbowman
#cleararmor
#spr1 "MA_Quixote/QuixoteCrossbow1.tga"
#spr2 "MA_Quixote/QuixoteCrossbow2.tga"
#name "Ballestero"
#descr "Quijote has never gone to war and has no organized army, nor the infrastructure to create one. The Ballestero is the closest thing to 'soldiers' under Quijote's command. They are the professional guards of the castles, forts, and mansions that dot the realm's peaceful valleys and are paid handsome stipends to stand around on high walls all day and do nothing. Ballesteros love to train and shoot targets all day, and despite having practically no combat experience save for the occasional burglary attempt, they are incredibly precise marksmen. Quijote is a land of heroes, and an exceptional Ballestero may be turned into a commander via ritual, and in the process become a powerful icon and gain abilities far beyond their usual potential."
#gcost 10011
#rcost 1
#rpcost 10
#hp 11
#rcost 8
#prec 14
#att 11
#def 12
#mor 14
#armor 9
#armor 20
#magicskill 9 2
#custommagic 2304 100
#holy
#nametype 114
#end --divine name'd crossbowman has double fire crossbow, not regular soldier

#newmonster 6723
#copystats 2129
#clearweapons
#cleararmor
#name "Hidalgo"
#spr1 "MA_Quixote/QuixoteHidalgo1.tga"
#spr2 "MA_Quixote/QuixoteHidalgo2.tga"
#unmountedspr1 "MA_Quixote/QuixoteHidalgoNM1.tga"
#unmountedspr2 "MA_Quixote/QuixoteHidalgoNM2.tga"
#descr "Hidalgos are the sleepy, lazy nobles of common Quijote who are eager to become knights. They answer the Call to Errantry with fervent vigor, grabbing the best arms and horse they have available and making towards the road in search of quest and lady love. Hildalgo are not incredibly skilled but have unsurpassed morale. Quijote is a land of heroes, and an exceptional Hidalgo may be turned into a commander via ritual, and in the process become a powerful icon and gain abilities far beyond their usual potential."
#gcost 10010
#rpcost 9990
#hp 14
#rcost 6
#ressize 2
#mor 15
#mr 11
#weapon 357
#armor 9
#armor 2
#armor 20
#skilledrider 1
#magicskill 9 2
#custommagic 3072 100
#holy
#nametype 114
#mountmnr 6783
#end

#newmonster 6778
#copystats 50
#cleararmor
#clearweapons
#name "Almogaver"
#spr1 "MA_Quixote/QuixoteAlmogavar1.tga"
#spr2 "MA_Quixote/QuixoteAlmogavar2.tga"
#descr "In the wilderness and borderlands of Quijote live foreign mercenaries and unscrupulous brigands. The Almogaver live in the brutal mountains of Quijote's far frontiers, where they rear animals. They are skilled and ferocious warriors, who carry two javelins, a sling and a falchion. Almogavar can endure the harsh conditions of forests and mountains, and can go multiple days without eating. They are skilled raiders, and are known to make campaigns from their mountain homes to the nearby villages, pillaging them and taking back prisoners to ransom."
#gcost 10010
#rcost 1
#rpcost 12
#hp 12
#str 11
#att 11
#def 11
#prec 12
#mor 10
#ap 13
#weapon 10
#weapon 21
#weapon 22
#armor 44
#armor 20
#pillagebonus 2
#forestsurvival
#mountainsurvival
#skirmisher 1
#nametype 114
#end

#newmonster 6779
#copystats 287
#clearweapons
#cleararmor
#name "Ecorcheur"
#spr1 "MA_Quixote/QuixoteFlayer1.tga"
#spr2 "MA_Quixote/QuixoteFlayer2.tga"
#descr "In the wilderness and borderlands of Quijote live foreign mercenaries and unscrupulous brigands. The Ecorcheur are armed villains who terrorize farms and villages on the borderlands of Quijote. They rob all who they come across, stripping them of everything up to the clothes on their back. Ecorcheur were originally mercenaries and soldiers, but now they have no employer and have been disbanded without pay. They are skilled pillagers, and cause chaos and disarray wherever they go."
#gcost 10013
#rcost 1
#rpcost 6
#mor 9
#mapmove 14
#enc 3
#armor 5
#armor 120
#weapon 23
#weapon 18
#forestsurvival
#pillagebonus 1
#nametype 114
#incunrest 2
#end

#newmonster 6780
#copystats 289
#name "Routier"
#spr1 "MA_Quixote/QuixoteRoutierPike1.tga"
#spr2 "MA_Quixote/QuixoteRoutierPike2.tga"
#descr "In the wilderness and borderlands of Quijote live foreign mercenaries and unscrupulous brigands. Routiers are professional soldiers who are loyal to no crown or flag, and often travel over vast countries to participate in different campaigns or contracts. The dukes of Quijote have trouble creating large armies, so to fuel their endless disputes and rivalries they hire Routiers to campaign for them. Routiers have good armaments and are good pillagers, and during the times of truces and peace treaties they will often take to pillaging and brutalizing the surrounding populace in order to feed themselves."
#gcost 10009
#rpcost 8
#att 11   
#mor 10
#pillagebonus 1
#end

#newmonster 6781
#copystats 287
#cleararmor
#clearweapons
#name "Routier"
#spr1 "MA_Quixote/QuixoteRoutierSword1.tga"
#spr2 "MA_Quixote/QuixoteRoutierSword2.tga"
#descr "In the wilderness and borderlands of Quijote live foreign mercenaries and unscrupulous brigands. Routiers are professional soldiers who are loyal to no crown or flag, and often travel over vast countries to participate in different campaigns or contracts. The dukes of Quijote have trouble creating large armies, so to fuel their endless disputes and rivalries they hire Routiers to campaign for them. Routiers have good armaments and are good pillagers, and during the times of truces and peace treaties they will often take to pillaging and brutalizing the surrounding populace in order to feed themselves." 
#gcost 10009
#rpcost 9
#att 11
#def 11
#weapon 8
#armor 20
#armor 14
#armor 1
#pillagebonus 1
#end

-- Horse --
#newmonster 6783 -- Hidalgo
#copystats 3514 -- war horse
#copyspr 3514
#holy
#end

#newmonster 6784 -- Knight-Errant Horse
#copystats 3517 -- destrier
#copyspr 3517
#holy
#bravemount 100
#end



-- Special --

#newmonster 6713 -- quixote scout prophet form
#copystats 2325
#name "Adventurer"
#descr "A hero of the people who wanders about in search of magical treasure, or the completion of some fantastical quest. The adventurers of Quijote are numerous and forthcoming, and are willing to scout, spy, and campaign in the service of the Awakening God. Most adventurers will not aspire to much, but extraordinary ones may be made prophets, and turn into great and powerful heros."
#spr1 "MA_Quixote/QuixoteProphet1.tga"
#spr2 "MA_Quixote/QuixoteProphet2.tga"
#hp 17
#prec 13
#mr 13
#mor 14
#itemslots 2039814
#holy
#stealthy 17
#spy
#nametype 114
#inspirational 1
#end
--
#newmonster 6724
#copystats 6721
#spr1 "MA_Quixote/QuixoteDuelist1.tga"
#spr2 "MA_Quixote/QuixoteDuelist2.tga"
#name "Vainquer"
#descr "A Vainquer is an Escrimeur who has surpassed expectations and become a powerful and famous hero. Bards sing tales of their deeds, and kings and peasants alike spread rumors of them and root for their success. Vainquers have fighting skills of almost inhuman capacity, and can so easily dodge and parry attacks that legends say non-magical weapons cannot touch them. They can fight an army singlehandedly, and slay a dragon in one strike. Vainquer are trained in the arts of magic by the occultists of Quijote, memorizing magical words and somatic gestures for use in warfare. This objective understanding of the arcane makes them great at casting spells in combat, but rather terrible researchers."
#hp 15
#att 15
#def 14
#ap 16
#armor 9
#invulnerable 25
#unsurr 1
#okleader
#addrandomage 6
#mor 15
#researchbonus -5
#combatcaster
#startheroab 50
#end

--
#newmonster 6725
#copystats 6722
#clearweapons
#name "Tirador"
#spr1 "MA_Quixote/QuixoteTirador1.tga"
#spr2 "MA_Quixote/QuixoteTirador2.tga"
#descr "A Tirador is a Ballestero who has surpassed expectations and become a powerful and famous hero. Bards sing tales of their deeds, and kings and peasants alike spread rumors of them and root for their success. Tiradors are inhuman marksmen and masters of the crossbow. They can effortlessly dodge enemy arrows and can keep their aim steady even in overwhelming odds. Tiradors are known for accomplishing impossible deeds like sniping generals from across valleys and taking down towering cyclopses with one careful shot. They typically gather bands of merry men throughout their adventures, who aid them in battle and spread the word of their heroism. Tiradors are trained in the arts of magic by the occultists of Quijote, memorizing magical words and somatic gestures for use in warfare. This objective understanding of the arcane makes them great at casting spells in combat, but rather terrible researchers. Tiradors can shoot their crossbows twice as fast as usual, due to their veteran proficiency. This effect does not carry over to any items they may be given."
#weapon 1360
#weapon 8
#hp 14
#att 12
#prec 15
#ap 16
#mor 15
#invulnerable 15
#unsurr 1
#okleader
#addrandomage 6
#researchbonus -5
#combatcaster
#startheroab 50
#batstartsum2d6 482
#end

--
#newmonster 6726
#copystats 6723
#clearweapons
#cleararmor
#name "Knight-Errant"
#spr1 "MA_Quixote/QuixoteKnight1.tga"
#spr2 "MA_Quixote/QuixoteKnight2.tga"
#unmountedspr1 "MA_Quixote/QuixoteKnightNM1.tga"
#unmountedspr2 "MA_Quixote/QuixoteKnightNM2.tga"
#descr "A Knight-Errant is a Hidalgo who has surpassed expectations and, against all odds, become a powerful and famous hero. Bards sing tales of their deeds, and kings and peasants alike spread rumors of them and root for their success. Knight-Errants are fanatic and powerful paladins of the Awakening God, who have sworn to uphold their oaths and protect the sanctity of chivalry. Knight-Errants have effortlessly slain giants, thwarted wizards, and saved fair ladies from vile enchanters. They are valiant icons beloved by the people, and their mere presence sends fear into the hearts of Pretender Gods and false prophets. Knight-Errants are trained in the arts of magic by the occultists of Quijote, memorizing magical words and somatic gestures for use in warfare. This objective understanding of the arcane makes them great at casting spells in combat, but rather terrible researchers."
#weapon 4
#weapon "Spada da Lato"
#hp 16
#ap 21
#att 13
#def 13
#addrandomage 18
#armor 19
#armor 118
#armor 3
#holy
#skilledrider 3
#haltheretic 1
#researchbonus -5
#combatcaster
#startheroab 75
#batstartsum1 1565
#mountmnr 6784
#end

#newmonster 6727
#name "Hero from Afar"
#spr1 "MA_Quixote/QuixoteMysteryMan.tga"
#descr "A powerful warrior from a distant land who stands before Quijote's gates, ready to pledge their life in service, without really knowing why. While the madness of Quijote is usually contained to its Castilian population, great heroes from distant lands will occasionally fall victim to its toxic influence. Feeling the call, they will abandon their former lives and make the pilgrimage to the land of errantry. Shrouded in a mysterious disguise, they are useless in this form, and in order to join Quijote's campaign, they must reveal their identity by partaking in a ritualistic initiation, wherein, after a period of sombre meditation, they discard all aspects and allegiances of their former selves, finalizing their betrayal to their homeland."
#gcost 0
#hp 10
#size 2
#prot 0
#mr 15
#mor 8
#str 8
#att 8
#def 8
#prec 10
#enc 3
#mapmove 0
#ap 10
#noleader
#maxage 50
#immobile
#singlebattle
#itemslots 262144
#stealthy 20
#nohof
#startitem 600
#end



--------

#newmonster 6767
#copystats 587
#clearmagic
#clearweapons
#name "Apostle of Nature"
#fixedname "Franciscus"
#spr1 "MA_Quixote/QuixoteApostleNature1.tga"
#spr2 "MA_Quixote/QuixoteApostleNature2.tga"
#descr "Apostles are revered followers of the previous Pantokrator who aided in his original ascension as Lord. They no longer fear death or adversity since they have advanced to a new state of existence in the Celestial Sphere. Franciscus, a mystic and preacher, is the most venerated Saint of Quijote and the original founder of its holy order of mendicant friars. He was raised by wealthy merchants, but after encountering a vision of the Lord, he renounced this life in favor of one of servitude and poverty. At the end of his life, Franciscus was approached by a Seraph, and upon his death he was granted eternal life as a saint. He is heavily attuned to the path of nature and in battle animals will come to his aid. Saints radiate such a powerful aura of holy radiance that no mortal would dare to strike them, and a magnificent circle of light envelops their heads."
#nowish
#holy
#weapon 92
#armor 158
#gcost 0
#str 11
#mapmove 16
#mor 50
#maxage 1000
#unique
#forestsurvival
#addrandomage 6
#autodishealer 2
#awe 5
#entangle
#spiritsight
#batstartsum5d6 -5
#beastmaster 2
#magicskill 6 5
#magicskill 9 4
#bonusspells 1
--#commaster
#end

#newmonster 6768
#copystats 1536
#clearmagic
#clearweapons
#name "Apostle of Fire"
#fixedname "Ar'un Dar"
#descr "Apostles are revered followers of the previous Pantokrator who aided in his original ascension as Lord. They no longer fear death or adversity since they have advanced to a new state of existence in the Celestial Sphere. Ar'un Dar was born into a heretic clan of Abysians led by a warlock preaching the New Faith. He was confronted by a vision of the True Lord and blessed with the strength of fire. Wielding this holy strength, he created a great eruption of earth and magma, destroying his entire clan at once. After this, he went into hiding, living as a mendicant and a preacher until his natural death. Ar'un Dar is heavily attuned to the path of fire, and his reborn body radiates the heat of a furnace, exhausting and burning anyone nearby. Saints radiate such a powerful aura of holy radiance that no mortal would dare to strike them, and a magnificent circle of light envelops their heads. With Ar'un Dar's return, a cult of fire has formed among the superstitious of Quijote, and wherever he travels, heretical altars and occult rituals and offerings proliferate."
#spr1 "MA_Quixote/QuixoteApostleFire1.tga"
#spr2 "MA_Quixote/QuixoteApostleFire2.tga"
#nowish
#holy
#weapon 92
#armor 158
#gcost 0
#mor 50
#maxage 1000
#okleader
#unique
#addrandomage 6
#awe 5
#spiritsight
#wastesurvival
#magicskill 0 5
#magicskill 9 3
#bonusspells 1
--#commaster
#spreadchaos 1
#heretic 1
#speciallook 1
#end

#newmonster 6769
#copystats 187
#clearweapons
#cleararmor
#name "Apostle of Death"
#fixedname "Tomas Aisa"
#descr "Apostles are revered followers of the previous Pantokrator who aided in his original ascension as Lord. They no longer fear death or adversity since they have advanced to a new state of existence in the Celestial Sphere. Tomas Aisa is a folk saint worshipped in Quijote and the neighboring regions and is also known as 'San Tomas', 'San Tomas Muerte', and 'The Saint of Holy Death'. In strange and remote villages where the inquisition does not visit, peasants hoist skeletal idols and create macabre altars, where they pray to Tomas and demand wishes. Tomas Aisa was formerly a king of the underworld. He is attuned to the path of death, and when he returns to earth, he is surrounded by a splendour of flaming banefire. Everywhere he goes, a religion of death follows, and in his presence, heretical altars, occult rituals, and offerings proliferate. Saints radiate such a powerful aura of holy radiance that no mortal would dare to strike them, and a magnificent circle of light envelops their heads."
#spr1 "MA_Quixote/QuixoteApostleDeath1.tga"
#spr2 "MA_Quixote/QuixoteApostleDeath2.tga"
#nowish
#holy
#weapon 92
#armor 158
#hp 15
#gcost 0
#mor 50
#maxage 1000
#okleader
#unique
#addrandomage 6
#awe 5
#spiritsight
#bonusspells 1
--#commaster
#autohealer 2
#magicskill 5 5
#magicskill 9 3
#banefireshield 8
#spreadchaos 1
#heretic 1
#prec 12
#speciallook 2
#end

#newmonster 6770
#copystats 587
#clearmagic
#clearweapons
#name "Apostle of Earth"
#fixedname "Aristarchus of the Caves"
#spr1 "MA_Quixote/QuixoteApostleEarth1.tga"
#spr2 "MA_Quixote/QuixoteApostleEarth2.tga"
#descr "Apostles are revered followers of the previous Pantokrator who aided in his original ascension as Lord. They no longer fear death or adversity since they have advanced to a new state of existence in the Celestial Sphere. Saint Aristarchus was a traveling sage and monk who explored the earth in pursuit of architectural mastery. He uncovered Agartha's subterranean halls during his explorations, where he researched their control over the earth and stone and advanced the reign of the True Lord. He spent the end of his life in a cavern monastery, devoted to manuscript and study. Aristarchus is heavily attuned to the path of earth, and he can be tasked with enchanting powerful statues, recreations of the sentries he saw in his travels through the underground. A cult of the earth takes root among the superstitious with Aristarchus' return, and wherever he goes, heretical altars and occult rituals and offerings spread. Saints radiate such a powerful aura of holy radiance that no mortal would dare to strike them, and a magnificent circle of light envelops their heads."
#nowish
#holy
#weapon 92
#gcost 0
#mor 50
#maxage 1000
#okleader
#unique
#addrandomage 6
#awe 5
#spiritsight
#bonusspells 1
--#commaster
#prec 9
#darkvision 50
#mason
#inspiringres 1
#magicskill 3 5
#magicskill 9 3
#makemonsters1 474
#spreadchaos 1
#heretic 1
#end

#newmonster 6771
#copystats 104
#clearmagic
#name "Apostle of Water"
#fixedname "Adjutor"
#spr1 "MA_Quixote/QuixoteApostleWater1.tga"
#spr2 "MA_Quixote/QuixoteApostleWater2.tga"
#descr "Apostles are revered followers of the previous Pantokrator who aided in his original ascension as Lord. They no longer fear death or adversity since they have advanced to a new state of existence in the Celestial Sphere. Adjutor is a renowned water magic student and a former acolyte of the Coral Towers of Atlantis. After being accosted by angels and instructed to give up the cult of the deep, it is reported that he journeyed by walking over the ocean floor, joining an abbey on the Quijote coast, and spending the remainder of his life as a hermit. Adjutor is attuned to the path of water and is able to grant water breathing to those under his command, as well as harness the abilities of a seer. The cult of the deep surreptitiously spreads in Adjutor's presence, drawing the innocent people of Quijote to the coast to engage in heretical worship. Saints radiate such a powerful aura of holy radiance that no mortal would dare to strike them, and a magnificent circle of light envelops their heads."
#armor 158
#gcost 0
#mor 50
#maxage 1000
#okleader
#unique
#addrandomage 6
#awe 5
#spiritsight
#bonusspells 1
--#commaster
#ap 9
#giftofwater 50
#magicskill 2 5
#magicskill 9 3
#spreadchaos 1
#heretic 1
#end

#newmonster 6772
#copystats 2570
#clearmagic
#clearweapons
#name "Apostle of Air"
#fixedname "Manuchahr"
#spr1 "MA_Quixote/QuixoteApostleAir1.tga"
#spr2 "MA_Quixote/QuixoteApostleAir2.tga"
#descr "Apostles are revered followers of the previous Pantokrator who aided in his original ascension as Lord. They no longer fear death or adversity since they have advanced to a new state of existence in the Celestial Sphere. Manuchahr is a Caelian saint of the winds and the sky.  He disregarded the ancestral religion and earned a reputation among the mountain people as a preacher of the True Lord. Manuchahr is attuned to the path of air and his divine form can fly through storms. Upon Manuchahr's return, a religion among Quijote's heretics emerges that turns to worshiping the ancient Yazatas, and wherever he goes, heretic worship grows."
#nowish
#holy
#armor 158
#weapon 7
#gcost 0
#mor 50
#maxage 1000
#okleader
#unique
#addrandomage 6
#awe 6
#spiritsight
#bonusspells 1
--#commaster
#str 10
#hp 10
#magicskill 1 5
#magicskill 9 3
#spreadchaos 1
#heretic 1
#stormimmune
#end

-- Added from DE, giant transformation monster
#newmonster 6762
#copystats 2641 -- Giant Mage
#copyspr 2641 -- Giant Mage
#clearmagic
#name "Transformed Giant"
#descr "This is a mage transformed into the form of a Giant by magic. The gigantic body is strong and healthy. The mage will retain any magic skills learned before the transformation took place."
#mor 16
#transformation 0
#digest 2
#twiceborn 3445
#end

-- Added from DE, dragon transformation monster
#newmonster 6763
#copystats 2534 -- Dragon (Red)
#clearmagic
#copyspr 2534
#name "Transformed Dragon"
#descr "This is a mage transformed into the form of a powerful Dragon by magic. The body of the Dragon will be strong and protected by iron hard scales, and the creature can breathe fire. Dragons have voracious appetites and will eat as much as twenty men. The Dragon will retain any magic skills learned before the transformation took place, and Fire magic will be easier whilst in Dragon form. Drakes and lesser draconic beings will be summoned in greater numbers when summoned by a mage in dragon form."
#lizard
#supplybonus -20
#gcost 0
#prot 20
#noleader
#mor 16
#hp 125
#dragonlord 2
#magicboost 0 1
#twiceborn 644
#end

---

#newmonster 6773
#copystats 2229
#copyspr 2229
#startaff 50
#montag 2230
#end

#newmonster 6774
#copystats 2230
#copyspr 2230
#startaff 50
#montag 2230
#end

-- GLOBAL FREESPAWN --

#newmonster 6728
#copystats 217
#clearspec
#clearweapons
#name "Quijote Faithful"
#descr "A victim of Quijote's madness, Faithfuls are devout conscripts determined to rid the world the of false prophets and Pretender Gods. They may or may not have suitable training or arms depending on their background. All Faithfuls possess unequaled fighting morale."
#spr1 "MA_Quixote/QuixoteFGreatSword11.tga"
#spr2 "MA_Quixote/QuixoteFGreatSword12.tga"
#gcost 0
#neednoteat
#supplybonus -1
#att 9
#def 9
#prec 5
#armor 20
#armor 9
#weapon 11
#montag 3002 --Everywhere but caves
#end 

#newmonster 6729
#copystats 6728
#spr1 "MA_Quixote/QuixoteFGreatSword21.tga"
#spr2 "MA_Quixote/QuixoteFGreatSword22.tga"
#cleararmor
#armor 9
#montag 3002 --Everywhere but caves
#end

#newmonster 6730
#copystats 6728
#spr1 "MA_Quixote/QuixoteFHalberd11.tga"
#spr2 "MA_Quixote/QuixoteFHalberd12.tga"
#clearweapons
#weapon 5
#montag 3002 --Everywhere but caves
#end

#newmonster 6731
#copystats 6729
#spr1 "MA_Quixote/QuixoteFHalberd21.tga"
#spr2 "MA_Quixote/QuixoteFHalberd22.tga"
#clearweapons
#weapon 5
#montag 3002 --Everywhere but caves
#end

#newmonster 6732
#copystats 39
#copyspr 39
#name "Quijote Faithful"
#descr "A victim of Quijote's madness, Faithfuls are devout conscripts determined to rid the world the of false prophets and Pretender Gods. They may or may not have suitable training or arms depending on their background. All Faithfuls possess unequaled fighting morale."
#gcost 0
#neednoteat
#supplybonus -1
#mor 14
#montag 3002 --Everywhere but caves
#end

#newmonster 6733
#copystats 6732
#spr1 "MA_Quixote/QuixoteFHInfantry21.tga"
#spr2 "MA_Quixote/QuixoteFHInfantry22.tga"
#cleararmor
#armor 12
#armor 2
#montag 3002 --Everywhere but caves
#end

#newmonster 6734
#copystats 29
#name "Quijote Faithful"
#descr "A victim of Quijote's madness, Faithfuls are devout conscripts determined to rid the world the of false prophets and Pretender Gods. They may or may not have suitable training or arms depending on their background. All Faithfuls possess unequaled fighting morale."
#spr1 "MA_Quixote/QuixoteFJavInfantry11.tga"
#spr2 "MA_Quixote/QuixoteFJavInfantry12.tga"
#gcost 0
#neednoteat
#supplybonus -1
#mor 14
#montag 3002 --Everywhere but caves
#end

#newmonster 6735
#copystats 6734
#cleararmor
#armor 5
#armor 2
#spr1 "MA_Quixote/QuixoteFJavInfantry21.tga"
#spr2 "MA_Quixote/QuixoteFJavInfantry22.tga"
#montag 3002 --Everywhere but caves
#end

#newmonster 6736
#copystats 6734
#cleararmor
#spr1 "MA_Quixote/QuixoteFJavInfantry31.tga"
#spr2 "MA_Quixote/QuixoteFJavInfantry32.tga"
#armor 2
#montag 3002 --Everywhere but caves
#end

#newmonster 6737
#copystats 28
#name "Quijote Faithful"
#descr "A victim of Quijote's madness, Faithfuls are devout conscripts determined to rid the world the of false prophets and Pretender Gods. They may or may not have suitable training or arms depending on their background. All Faithfuls possess unequaled fighting morale."
#spr1 "MA_Quixote/QuixoteFLightInfantry11.tga"
#spr2 "MA_Quixote/QuixoteFLightInfantry12.tga"
#gcost 0
#neednoteat
#supplybonus -1
#mor 14
#montag 3002 --Everywhere but caves
#end

#newmonster 6738
#copystats 6737
#spr1 "MA_Quixote/QuixoteFLightInfantry21.tga"
#spr2 "MA_Quixote/QuixoteFLightInfantry22.tga"
#cleararmor
#armor 6
#armor 2
#montag 3002 --Everywhere but caves
#end

#newmonster 6739
#copystats 6737
#spr1 "MA_Quixote/QuixoteFLightInfantry31.tga"
#spr2 "MA_Quixote/QuixoteFLightInfantry32.tga"
#cleararmor
#armor 2
#montag 3002 --Everywhere but caves
#end

#newmonster 6740
#copystats 24
#name "Quijote Faithful"
#descr "A victim of Quijote's madness, Faithfuls are devout conscripts determined to rid the world the of false prophets and Pretender Gods. They may or may not have suitable training or arms depending on their background. All Faithfuls possess unequaled fighting morale."
#spr1 "MA_Quixote/QuixoteFLightCav11.tga"
#spr2 "MA_Quixote/QuixoteFLightCav12.tga"
#gcost 0
#neednoteat
#supplybonus -2
#mor 14
#montag 3003 --plains, mountains, and wastes
#end

#newmonster 6741
#copystats 6737
#spr1 "MA_Quixote/QuixoteFLightCav21.tga"
#spr2 "MA_Quixote/QuixoteFLightCav22.tga"
#cleararmor
#armor 5
#montag 3003 --plains, mountains, and wastes
#end

#newmonster 6742
#copystats 26
#name "Quijote Faithful"
#descr "A victim of Quijote's madness, Faithfuls are devout conscripts determined to rid the world the of false prophets and Pretender Gods. They may or may not have suitable training or arms depending on their background. All Faithfuls possess unequaled fighting morale."
#spr1 "MA_Quixote/QuixoteFMedCav11.tga"
#spr2 "MA_Quixote/QuixoteFMedCav12.tga"
#gcost 0
#neednoteat
#supplybonus -2
#mor 14
#montag 3003 --plains, mountains, and wastes
#end

#newmonster 6743
#copystats 2504
#name "Quijote Faithful"
#descr "A victim of Quijote's madness, Faithfuls are devout conscripts determined to rid the world the of false prophets and Pretender Gods. They may or may not have suitable training or arms depending on their background. All Faithfuls possess unequaled fighting morale."
#spr1 "MA_Quixote/QuixoteFZot1.tga"
#spr2 "MA_Quixote/QuixoteFZot2.tga"
#gcost 0
#neednoteat
#supplybonus -1
#mor 14
#montag 3004 --caves only
#end

#newmonster 6744
#copystats 1394
#copyspr 1394
#name "Quijote Faithful"
#descr "A victim of Quijote's madness, Faithfuls are devout conscripts determined to rid the world the of false prophets and Pretender Gods. They may or may not have suitable training or arms depending on their background. All Faithfuls possess unequaled fighting morale."
#gcost 0
#mor 14
#montag 3004 --caves only
#end

#newmonster 6745
#copystats 1615
#copyspr 1615
#name "Quijote Faithful"
#descr "A victim of Quijote's madness, Faithfuls are devout conscripts determined to rid the world the of false prophets and Pretender Gods. They may or may not have suitable training or arms depending on their background. All Faithfuls possess unequaled fighting morale."
#gcost 0
#neednoteat
#supplybonus -2
#mor 14
#montag 3004 --caves only
#end

#newmonster 6746
#copystats 1465
#copyspr 1465
#name "Quijote Faithful"
#descr "A victim of Quijote's madness, Faithfuls are devout conscripts determined to rid the world the of false prophets and Pretender Gods. They may or may not have suitable training or arms depending on their background. All Faithfuls possess unequaled fighting morale."
#gcost 0
#mor 14
#montag 3004 --caves only
#end

#newmonster 6747
#copystats 3276
#copyspr 3276
#name "Quijote Faithful"
#descr "A victim of Quijote's madness, Faithfuls are devout conscripts determined to rid the world the of false prophets and Pretender Gods. They may or may not have suitable training or arms depending on their background. All Faithfuls possess unequaled fighting morale."
#gcost 0
#neednoteat
#supplybonus -2
#mor 14
#montag 3004 --caves only
#end

#newmonster 6748
#copystats 3277
#copyspr 3277
#name "Quijote Faithful"
#descr "A victim of Quijote's madness, Faithfuls are devout conscripts determined to rid the world the of false prophets and Pretender Gods. They may or may not have suitable training or arms depending on their background. All Faithfuls possess unequaled fighting morale."
#gcost 0
#neednoteat
#supplybonus -2
#mor 14
#montag 3004 --caves only
#end

#newmonster 6749
#copystats 271
#copyspr 271
#name "Quijote Faithful"
#descr "A victim of Quijote's madness, Faithfuls are devout conscripts determined to rid the world the of false prophets and Pretender Gods. They may or may not have suitable training or arms depending on their background. All Faithfuls possess unequaled fighting morale."
#gcost 0
#neednoteat
#supplybonus -1
#mor 14
#montag 3005 --farms only
#end

#newmonster 6750
#copystats 273
#copyspr 273
#name "Quijote Faithful"
#descr "A victim of Quijote's madness, Faithfuls are devout conscripts determined to rid the world the of false prophets and Pretender Gods. They may or may not have suitable training or arms depending on their background. All Faithfuls possess unequaled fighting morale."
#gcost 0
#neednoteat
#supplybonus -1
#mor 14
#montag 3005 --farms only
#end

#newmonster 6751
#copystats 423
#copyspr 423
#name "Quijote Faithful"
#descr "A victim of Quijote's madness, Faithfuls are devout conscripts determined to rid the world the of false prophets and Pretender Gods. They may or may not have suitable training or arms depending on their background. All Faithfuls possess unequaled fighting morale."
#gcost 0
#neednoteat
#supplybonus -1
#mor 14
#montag 3006 --swamp and forest
#end

#newmonster 6752
#copystats 205
#copyspr 205
#name "Quijote Faithful"
#descr "A victim of Quijote's madness, Faithfuls are devout conscripts determined to rid the world the of false prophets and Pretender Gods. They may or may not have suitable training or arms depending on their background. All Faithfuls possess unequaled fighting morale."
#gcost 0
#neednoteat
#supplybonus -1
#mor 14
#montag 3007 --highlands
#end

#newmonster 6753
#copystats 6744
#copyspr 6744
#montag 3007 --highlands
#end

#newmonster 6754
#copystats 1395
#copyspr 1395
#name "Quijote Faithful"
#descr "A victim of Quijote's madness, Faithfuls are devout conscripts determined to rid the world the of false prophets and Pretender Gods. They may or may not have suitable training or arms depending on their background. All Faithfuls possess unequaled fighting morale."
#gcost 0
#mor 14
#montag 3007 --highlands
#end

#newmonster 6755
#copystats 974
#copyspr 974
#name "Quijote Faithful"
#descr "A victim of Quijote's madness, Faithfuls are devout conscripts determined to rid the world the of false prophets and Pretender Gods. They may or may not have suitable training or arms depending on their background. All Faithfuls possess unequaled fighting morale."
#gcost 0
#neednoteat
#supplybonus -1
#mor 14
#montag 3008 --coast
#end

#newmonster 6756
#copystats 975
#copyspr 975
#name "Quijote Faithful"
#descr "A victim of Quijote's madness, Faithfuls are devout conscripts determined to rid the world the of false prophets and Pretender Gods. They may or may not have suitable training or arms depending on their background. All Faithfuls possess unequaled fighting morale."
#gcost 0
#neednoteat
#supplybonus -1
#mor 14
#montag 3008 --coast and shallow sea
#end

#newmonster 6756
#copystats 206
#copyspr 206
#name "Quijote Faithful"
#descr "A victim of Quijote's madness, Faithfuls are devout conscripts determined to rid the world the of false prophets and Pretender Gods. They may or may not have suitable training or arms depending on their background. All Faithfuls possess unequaled fighting morale."
#gcost 0
#neednoteat
#supplybonus -2
#mor 14
#montag 3008 --coast and shallow sea
#end

#newmonster 6757
#copystats 174
#copyspr 174
#name "Quijote Faithful"
#descr "A victim of Quijote's madness, Faithfuls are devout conscripts determined to rid the world the of false prophets and Pretender Gods. They may or may not have suitable training or arms depending on their background. All Faithfuls possess unequaled fighting morale."
#gcost 0
#neednoteat
#supplybonus -1
#mor 14
#montag 3009 --all of sea
#end

#newmonster 6758
#copystats 175
#copyspr 175
#name "Quijote Faithful"
#descr "A victim of Quijote's madness, Faithfuls are devout conscripts determined to rid the world the of false prophets and Pretender Gods. They may or may not have suitable training or arms depending on their background. All Faithfuls possess unequaled fighting morale."
#gcost 0
#neednoteat
#supplybonus -1
#mor 14
#montag 3009 --all of sea
#end

#newmonster 6759
#copystats 577
#copyspr 577
#name "Quijote Faithful"
#descr "A victim of Quijote's madness, Faithfuls are devout conscripts determined to rid the world the of false prophets and Pretender Gods. They may or may not have suitable training or arms depending on their background. All Faithfuls possess unequaled fighting morale."
#gcost 0
#neednoteat
#supplybonus -1
#mor 14
#montag 3009 --all of sea
#end

#newmonster 6760
#copystats 1060
#copyspr 1060
#name "Quijote Faithful"
#descr "A victim of Quijote's madness, Faithfuls are devout conscripts determined to rid the world the of false prophets and Pretender Gods. They may or may not have suitable training or arms depending on their background. All Faithfuls possess unequaled fighting morale."
#gcost 0
#neednoteat
#supplybonus -2
#mor 14
#montag 3009 --all of sea
#end

#newmonster 6761
#copystats 545
#copyspr 545
#name "Quijote Faithful"
#descr "A victim of Quijote's madness, Faithfuls are devout conscripts determined to rid the world the of false prophets and Pretender Gods. They may or may not have suitable training or arms depending on their background. All Faithfuls possess unequaled fighting morale."
#gcost 0
#neednoteat
#supplybonus -5
#mor 14
#montag 3009 --all of sea
#end

-------- NATION --------

#selectnation 146
#name "Quijote"
#epithet "Call to Errantry"
#era 2
#descr "Hidden in the sleepy valleys of Marignon, the cities of Quijote have not seen much conflict. It's a realm of merry-making, wine-tasting, late mornings, and early evenings. However, with the disappearance of the Pantokrator, madness brews in Quijote. This madness is a thirst for adventure! The desire to go on exciting journeys, accomplish perilous quests, and save fair maidens. Farmers and noblemen alike grab their lineal arms and make their way towards the roads, determined to become famous heroes. Secret societies of occultists train and study in secluded caves, towers, and elite academies. Reclusive magicians have emerged from hiding and wield exotic and rare sorceries. Skilled prodigies duel in the streets, and merry men pull off daring escapades. The mad old dukes raise armies of fanatic crusaders, and deft champions are trained in secret to be unleashed upon Quijote's enemies.

The people of Quijote are extremely superstitious and are quick to accept foreign beliefs and fascinating cults. The peasantry worship folk saints and strange icons away from prying eyes, and noble courts pray to the divine for boons and divination. The Awakening God is seen as Pantokrator Almighty, and all other gods are simply agents in his will, destined to join his sanctorum upon ascension. Temples and religious sites of other faiths are assimilated and the faith of the Awakening One is imposed on newly conquered lands." 
#summary "Race: Humans. Randomly receives powerful heros and champions who may be elves, giants, or monsters.
Military: Heavily skilled but unorganized swashbucklers, crossbowmen, and high morale cavalry. Units may be promoted into leaders to gain more powerful skills and extra abilites. Brigands and outcasts can be recruited outside of forts. Cheaper mercenaries.
Magic: High astral, medium fire. Unreliable access to all paths.
Priests: Weak, but also have low access to random paths of magic."
#brief "Quijote is a realm of native kingdoms being influenced by a manipulating, conspiring god. They have no traditional army and instead rely on powerful heros and roving adventurers. Quijote has unreliable access to every path of magic, as wizards from far and wide abandon their posts to answer it's call."
#color 1.0 1.0 0.9
#secondarycolor 1.0 0.65 0
#flag "MA_Quixote/QuixoteFlag.tga"
#likesterr 256
#aiastralnation
#aigoodbless 100
#aiholyranged
#cavenation 0
#likespop 47
#fortera 2
#fortcost 30
#templecost 500
#templepic 3
#merccost -25
#defsloth 1
#astralblessbonus 1
#natureblessbonus 1
#fireblessbonus 1
#greekreanim
#syncretism 1 
#startsite "Bastion of the Sun"
#startsite "Academy of the Occult"

-- Pretender settings --

#homerealm 10
#homerealm 3
#addgod 550
#addgod 607
#addgod 608
#addgod 657
#addgod 1025
#addgod 2798
#addgod 120
#addgod 215
#addgod 2786
#addgod 2787
#addgod 2788
#cheapgod20 251
#cheapgod20 244
#cheapgod20 550
#cheapgod20 215
#cheapgod40 216
#cheapgod40 3416
#cheapgod20 3395

-- Units --

#startcom "Duque"
#startscout 6712
#startunittype1 "Escrimeur"
#startunitnbrs1 20
#startunittype2 "Hidalgo"
#startunitnbrs2 5

-- Add Soldiers

#addrecunit "Hermano"
#addrecunit 6780
#addrecunit 6781
#addrecunit "Ballestero"
#addrecunit "Escrimeur"
#addrecunit "Hidalgo"
#forestrec "Almogaver"
#mountainrec "Almogaver"
#addrecunit "Ecorcheur"
#addforeignunit 6780
#addforeignunit 6781
#addforeignunit "Ecorcheur"
-- Add Leaders

#addreccom 6712
#addreccom "Rogue"
--#addreccom 6718
#addreccom 6714
#addreccom "Magician"
#addreccom 478
#addreccom 551
--#addreccom 6719
#addreccom "Condottiero"
#addreccom 3486
#addreccom 3487


#addforeigncom 154
#addforeigncom "Condottiero"

#hero1 6775
#hero2 6776
#multihero1 6777
--#multihero2 6724
--#multihero3 6725
--#multihero4 6726


-- Province Defence -- !!SUBJECT TO CHANGE!!

#defcom1 "Duque"
#defcom2 6714
#defunit1 "Hermano"
#defunit1b "Ballestero"
#defmult1b 5
#defunit2 "Hidalgo"
#defmult2 1
#defunit2b "Escrimeur"
#defmult2b 5

#wallcom "Tirador"
#wallunit "Ballestero"
#wallmult 5
#end

----- EVENTS ----

#newevent
#rarity 5
#req_fornation 146
#req_pop0ok
#req_targmnr 6721
#req_targowner 146
#msg "An Escrimeur has been promoted. He is now a Vainquer."
#xp 2
#transform 6724
#end

#newevent
#rarity 5
#req_fornation 146
#req_pop0ok
#req_targmnr 6722
#req_targowner 146
#msg "A Ballestero has been promoted. He is now a Tirador."
#xp 2
#transform 6725
#end

#newevent
#rarity 5
#req_fornation 146
#req_pop0ok
#req_targmnr 6723
#req_targowner 146
#msg "A Hidalgo has been promoted. He is now a Knight-Errant."
#xp 2
#transform 6726
#end
--
#newevent -- triggers the popkill of tCoE
#req_ench 641
#rarity 5
#msg "Call to errantry"
#notext
#nolog
#kill 4
#unrest 12
#req_indepok 1
#req_pop0ok 1
#end

#newevent
#req_myench 641
#rarity 13
#req_owncapital 1
#req_unique 1
#req_pop0ok
#msg "A dire portent.
A massive arcane shockwave has been released from the lands of Quijote! The madness previously only felt by ##godname##'s forces and their heroes will now spread amongst the entire world, calling every farmer, soldier, beggar, and villain to become an adventurer and serve Quijote. Chaos and dilapidation will follow, and the enchantment will stay in effect until it is dispelled, Quijote is destroyed, or there is nobody left to answer it."

#newevent
#req_myench 641
#req_fornation 146
#req_minpop 1
#req_land 1
#req_cave 0
#req_fullowner 146
#req_domchance 3
#rarity 5
#msg "Call to errantry"
#notext
#nolog
#nation 146
#1d6units -3002
#end

#newevent
#req_myench 641
#req_fornation 146
#req_minpop 1
#req_land 1
#req_cave 1
#req_fullowner 146
#req_domchance 3
#rarity 5
#msg "Call to errantry"
#notext
#nolog
#nation 146
#1d6units -3004
#end

#newevent
#req_myench 641
#req_fornation 146
#req_minpop 1
#req_land 1
#req_forest 0
#req_coast 0
#req_swamp 0
#req_waste 0
#req_cave 0
#req_fullowner 146
#req_domchance 3
#rarity 5
#msg "Call to errantry"
#notext
#nolog
#nation 146
#1d6units -3003
#end

#newevent
#req_myench 641
#req_fornation 146
#req_minpop 1
#req_land 1
#req_farm 1
#req_fullowner 146
#req_domchance 3
#rarity 5
#msg "Call to errantry"
#notext
#nolog
#nation 146
#1d6units -3005
#end

#newevent
#req_myench 641
#req_fornation 146
#req_minpop 1
#req_land 1
#req_swamp 1
#req_fullowner 146
#req_domchance 3
#rarity 5
#msg "Call to errantry"
#notext
#nolog
#nation 146
#1d6units -3006
#end

#newevent
#req_myench 641
#req_fornation 146
#req_minpop 1
#req_land 1
#req_forest 1
#req_fullowner 146
#req_domchance 3
#rarity 5
#msg "Call to errantry"
#notext
#nolog
#nation 146
#1d6units -3006
#end

#newevent
#req_myench 641
#req_fornation 146
#req_minpop 1
#req_land 1
#req_mountain 1
#req_fullowner 146
#req_domchance 3
#rarity 5
#msg "Call to errantry"
#notext
#nolog
#nation 146
#1d6units -3007
#end

#newevent
#req_myench 641
#req_fornation 146
#req_minpop 1
#req_land 1
#req_coast 1
#req_fullowner 146
#req_domchance 3
#rarity 5
#msg "Call to errantry"
#notext
#nolog
#nation 146
#1d6units -3008
#end

#newevent
#req_myench 641
#req_fornation 146
#req_minpop 1
#req_land 0
#req_fullowner 146
#req_domchance 3
#rarity 5
#msg "Call to errantry"
#notext
#nolog
#nation 146
#1d6units -3009
#end

--
#newevent
#req_unluck 3
#req_rare 5
#req_fornation 146
#req_owncapital 1
#req_fullowner 146
#rarity 0
#req_pop0ok
#msg "A Hero from Afar has arrived in Quijote's capital and joined your service."
#nation 146
#com 6727
#end

#newevent
#req_unluck 2
#req_rare 6
#req_fornation 146
#req_owncapital 1
#req_fullowner 146
#rarity 0
#req_pop0ok
#msg "A Hero from Afar has arrived in Quijote's capital and joined your service."
#nation 146
#com 6727
#end

#newevent
#req_unluck 1
#req_rare 7
#req_fornation 146
#req_owncapital 1
#req_fullowner 146
#rarity 0
#req_pop0ok
#msg "A Hero from Afar has arrived in Quijote's capital and joined your service."
#nation 146
#com 6727
#end

#newevent
#req_luck 0
#req_rare 8
#req_fornation 146
#req_owncapital 1
#req_fullowner 146
#rarity 0
#req_pop0ok
#msg "A Hero from Afar has arrived in Quijote's capital and joined your service."
#nation 146
#com 6727
#end

#newevent
#req_luck 1
#req_rare 10
#req_fornation 146
#req_owncapital 1
#req_fullowner 146
#rarity 0
#req_pop0ok
#msg "A Hero from Afar has arrived in Quijote's capital and joined your service."
#nation 146
#com 6727
#end

#newevent
#req_luck 2
#req_rare 12
#req_fornation 146
#req_owncapital 1
#req_fullowner 146
#rarity 0
#req_pop0ok
#msg "A Hero from Afar has arrived in Quijote's capital and joined your service."
#nation 146
#com 6727
#end

#newevent
#req_luck 3
#req_rare 15
#req_fornation 146
#req_owncapital 1
#req_fullowner 146
#rarity 0
#req_pop0ok
#msg "A Hero from Afar has arrived in Quijote's capital and joined your service."
#nation 146
#com 6727
#end

#newevent
#rarity 5
#req_ench 642
#req_pop0ok
#msg "Hero Revealed"
#notext
#nolog
#killcom "Hero from Afar"
#end

--
#selectmonster 2229
#montag 2231
#end

#selectmonster 2230
#montag 2231
#end

-- HERO POOL --

#selectmonster 5
#montag 3000
#end

#selectmonster 6
#montag 3000
#end

#selectmonster 70
#montag 3000
#end

#selectmonster 113
#montag 3000
#end

#selectmonster 212
#montag 3000
#end

#selectmonster 236
#montag 3000
#end

#selectmonster 263
#montag 3000
#end

#selectmonster 437
#montag 3000
#end

#selectmonster 440
#montag 3000
#end

#selectmonster 441
#montag 3000
#end

#selectmonster 792
#montag 3000
#end

#selectmonster 850
#montag 3000
#end

#selectmonster 890
#montag 3000
#end

#selectmonster 1136
#montag 3000
#end

#selectmonster 1531
#montag 3000
#end

#selectmonster 1655
#montag 3000
#end

#selectmonster 2009
#montag 3000
#end

#selectmonster 2128
#montag 3000
#end

#selectmonster 2354
#montag 3000
#end

#selectmonster 2506
#montag 3000
#end

#selectmonster 2575
#montag 3000
#end

#selectmonster 2715
#montag 3000
#end

#selectmonster 3135
#montag 3000
#end

#selectmonster 3337
#montag 3000
#end

#selectmonster 3343
#montag 3000
#end

#selectmonster 23
#montag 3000
#end

#selectmonster 147
#montag 3000
#end

#selectmonster 272
#montag 3000
#end

#selectmonster 389
#montag 3000
#end

#selectmonster 391
#montag 3000
#end

#selectmonster 875
#montag 3000
#end

#selectmonster 2866
#montag 3000
#end

#selectmonster 2918
#montag 3000
#end

#selectmonster 37
#montag 3000
#end

#selectmonster 58
#montag 3000
#end

#selectmonster 540
#montag 3000
#end

#selectmonster 1806
#montag 3000
#end

#selectmonster 3474
#montag 3000
#end

#selectmonster 2359
#montag 3000
#end

#selectmonster 147
#montag 3000
#end

#selectmonster 366
#montag 3000
#end

#selectmonster 2331
#montag 3000
#end

#selectmonster 2932
#montag 3000
#end

#selectmonster 2900
#montag 3000
#end

#selectmonster 2323
#montag 3000
#end

#selectmonster 2324
#montag 3000
#end

#selectmonster 2325
#montag 3000
#end

#selectmonster 2332
#montag 3000
#end

#selectmonster 3615
#montag 3000
#end


--